'use strict';

describe('services/typeService.js', function () {

  var $type = null;

  beforeEach(module('genisis'));

  beforeEach(function () {
    inject(function (type) {
      $type = type;
    });
  });

  it('service exists', function () {
    expect($type).not.toBeNull();
  });

  describe('$type.toName() function', function () {
    it('exists', function () {
      expect($type.toName).toBeDefined();
    });

    it('returns valid type names', function () {
      expect($type.toName(1)).toEqual('Aggregate Data');
      expect($type.toName(2)).toEqual('Detail Data');
    });

    it('returns None if no ID is given', function () {
      expect($type.toName()).toEqual('None');
    });

    it('returns None if the ID is not found', function () {
      expect($type.toName(9999)).toEqual('None');
    });
  });

  describe('$type.find() function', function () {
    it('exists', function () {
      expect($type.find).toBeDefined();
    });

    it('returns null if no ID is given', function () {
      expect($type.find()).toEqual(null);
    });

    it('returns null if the type is not found', function () {
      expect($type.find(999)).toEqual(null);
    });

    it('returns the type if a valid ID is given', function () {
      expect($type.find(1)).toEqual({
        id: 1,
        name: 'Aggregate Data'
      });
      expect($type.find(2)).toEqual({
        id: 2,
        name: 'Detail Data'
      });
    });
  });

  describe('$type.get() function', function () {
    it('exists', function () {
      expect($type.get).toBeDefined();
    });

    it('returns all type objects', function () {
      expect($type.get()).toEqual(
        [{
          id: 2,
          name: 'Detail Data'
        }, {
          id: 1,
          name: 'Aggregate Data'
        }]
      );
    });
  });
});